<?php

    namespace DPP\Security\Encoders;

    use DPP\Security\Encoders\Exceptions\EncodingException;
    use DPP\Security\Encoders\Exceptions\JsonDecodingException;

    class JsonEncoder extends EncodingException
    {

        /**
         * Decode from JSON.
         *
         * @param string $jsonString
         *
         * @return mixed
         * @throws JsonDecodingException
         */
        public static function decode($jsonString)
        {
            $data  = json_decode($jsonString, true, 512, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
            $error = json_last_error();

            try {
                if ($error !== JSON_ERROR_NONE) {
                    throw new JsonDecodingException(sprintf('Unable to decode the given JSON string (%s).', $error));
                }
                else {
                    return $data;
                }
            }
            catch(JsonDecodingException $e)
            {
                echo $e->getMessage();
            }
        }

        /**
         * Convert given data to it JSON.
         *
         * @param mixed $data
         *
         * @return string
         * @throws JsonEncodingException
         */
        public static function encode($data)
        {
            $json  = json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
            $error = json_last_error();

            try {
                if ($error !== JSON_ERROR_NONE) {
                    throw new JsonEncodingException(sprintf('Unable to encode the given data (%s).', $error));
                }
                else {
                    return $json;
                }
            }
            catch(JsonEncodingException $e)
            {
                echo $e->getMessage();
            }
        }

        /**
         * Encode a json string in Base64 Url format.
         *
         * @param mixed $data
         *
         * @return string
         * @throws JsonEncodingException
         */
        public static function B64URLsafeEncode($data)
        {
            try {
                return B64Encoder::URLsafeEncode(self::encode($data));
            }
            catch (Exception $e) {

            }

        }

        /**
         * Decode a Base64 Url string to a json string
         *
         * @param string $base64Url
         *
         * @return string
         * @throws JsonDecodingException
         */
        public static function B64URLsafeDecode($base64Url)
        {
           return self::decode(B64Encoder::URLsafeDecode($base64Url));
        }
    }