<?php

namespace DPP\Security\Password;

use DPP\Security\Password\Rule\Rule;

class RuleSet
{
    private $rules;
    private $lockedIn;

    public function __construct()
    {
        $this->rules = array();
        $this->lockedIn = false;
    }

    public function add(Rule $r)
    {
        if(!$this->lockedIn)
        {
            $this->rules[] = $r;
        }
    }

    public function lock()
    {
        $this->lockedIn = true;
    }

    public function evaluate($pass)
    {
        $rt = [];

        foreach($this->rules as $r)
        {
            $rt[$r->identifier()] = $r->evaluate($pass);
        }

        return $rt;
    }

    public function weight()
    {

    }
}