<?php

namespace DPP\Security\Password\Rule;

class MaxLengthRule implements Rule
{
    private $length;

    public function __construct()
    {
        $this->length = null;
    }

    public function setValue($val)
    {
        $this->length = (int) $val;
    }

    public function weight()
    {

    }

    public function evaluate($pass)
    {
        return (strlen($pass) <= $this->length);
    }

    public function metric($wg)
    {

    }

    public function identifier()
    {
        return sprintf("%s_%s", get_class($this), $this->length);
    }
}