<?php

    namespace DPP\Security\Encoders;

    use DPP\Security\Encoders\Exceptions\UrlsafeDecodingException;
    use DPP\Security\Encoders\Exceptions\UrlsafeEncodingException;

    Class UrlsafeEncoder
    {

        /**
         * Encode a string to be "URL-safe".
         *
         * @param string $input The string you want encoded
         *
         * @return string
         */
        public static function encode($input) {
            return str_replace(['+', '/', '='], ['-', '_', ''], $input);
        }

        /**
         * Decode a string from "URL-safe".
         *
         * @param string $input A Base64 encoded string
         *
         * @return string A decoded string
         */
        public static function decode($input) {
            return str_replace(['-', '_'], ['+', '/'], $input);
        }

    }