<?php

    namespace DPP\Security\Encoders;

    use DPP\Security\Encoders\Exceptions\B64EncodingException;
    use DPP\Security\Encoders\Exceptions\B64DecodingException;

    Class B64Encoder
    {
        /**
         * Encode a string to Base64.
         *
         * @param string $input The string you want encoded
         *
         * @return string The base64 encode of what you passed in
         */
        public static function encode($input) {
            return base64_encode($input);
        }

        /**
         * Decode a string from Base64.
         *
         * @param string $input A Base64 encoded string
         *
         * @return string A decoded string
         */
        public static function decode($input) {
            return base64_decode(strtr($input, '-_', '+/'));
        }

        /**
         * Encode a string with URL-safe Base64.
         *
         * @param string $input The string you want encoded
         *
         * @return string The base64 encode of what you passed in
         */
        public static function URLsafeEncode($input) {

            return UrlsafeEncoder::encode(base64_encode($input));
        }

        /**
         * Decode a string with URL-safe Base64.
         *
         * @param string $input A Base64 encoded string
         *
         * @return string A decoded string
         */
        public static function URLsafeDecode($input) {
            // Some base64 URL strings may have missing padding which
            // is usually represented by the equals sign [=].

            return base64_decode( str_pad(UrlsafeEncoder::decode($input)
                                , strlen($input) % 4
                                , '='
                                , STR_PAD_RIGHT)
                               );
        }

    }