<?php

namespace DPP\Security\Encoders\Exceptions;
    
//namespace DPP\Security\Cryptography\JWT\Exceptions;

use Exception;

/**
 * An exception thrown if an Encoding related error is detected.
 */
class EncodingException extends Exception
{
    /**
     * Encoder for which exception was thrown.
     *
     * @var JWT|null
     */
    protected $encoder;

    /**
     * Construct a Encoder related exception.
     *
     * @param string   $message
     * @param JWT|null $encoder
     */
    public function __construct($message = '', $encoder = null)
    {
        $this->encoder = $encoder;

        parent::__construct($message);
    }

}
