<?php
    
    namespace DPP\Security\Cryptography\JWT\Interfaces;

    /**
     * Defines the list of claims that are registered in the IANA "JSON Web Token Claims" registry
     *
     * @see https://tools.ietf.org/html/rfc7519#section-4.1
     */
    interface Claims
    {
        const ALL = [
            self::AUDIENCE,
            self::EXPIRY,
            self::JID,
            self::ISSUED_AT,
            self::ISSUER,
            self::NOT_BEFORE,
            self::SUBJECT,
        ];

        const DATE_CLAIMS = [
            self::ISSUED_AT,
            self::NOT_BEFORE,
            self::EXPIRY,
        ];

        /**
         * Identifies the principal that issued the JWT
         *
         * @see https://tools.ietf.org/html/rfc7519#section-4.1.1
         */
        const ISSUER = 'iss';

        /**
         * Identifies the principal that is the subject of the JWT.
         *
         * https://tools.ietf.org/html/rfc7519#section-4.1.2
         */
        const SUBJECT = 'sub';

        /**
         * Identifies the recipients that the JWT is intended for
         *
         * @see https://tools.ietf.org/html/rfc7519#section-4.1.3
         */
        const AUDIENCE = 'aud';

        /**
         * Identifies the expiration time on or after which the JWT MUST NOT be accepted for processing
         *
         * @see https://tools.ietf.org/html/rfc7519#section-4.1.4
         */
        const EXPIRY = 'exp';

        /**
         * Identifies the time before which the JWT MUST NOT be accepted for processing
         *
         * https://tools.ietf.org/html/rfc7519#section-4.1.5
         */
        const NOT_BEFORE = 'nbf';

        /**
         * Identifies the time at which the JWT was issued
         *
         * @see https://tools.ietf.org/html/rfc7519#section-4.1.6
         */
        const ISSUED_AT = 'iat';

        /**
         * Provides a unique identifier for the JWT
         *
         * @see https://tools.ietf.org/html/rfc7519#section-4.1.7
         */
        const JID = 'jti';
    }
