<?php

namespace DPP\Security\Password;

use DPP\Security\Password\Rule\Rule;

class RuleSet
{
    private $rules;
    private $lockedIn;

    private $result;
    private $messages;

    public function __construct()
    {
        $this->rules = array();
        $this->lockedIn = false;

        $this->result = null;
        $this->messages = null;
    }

    public function add(Rule $r)
    {
        if(!$this->lockedIn)
        {
            $this->rules[] = $r;
        }
    }

    public function lock()
    {
        $this->lockedIn = true;
    }

    public function evaluate($pass)
    {
        $rt = [];
        $this->messages = array();

        foreach($this->rules as $r)
        {
            $rt[$r->identifier()] = $r->evaluate($pass);

            if(!$rt[$r->identifier()])
            {
                $this->messages[$r->identifier()] = $r->message();
            }
        }

        return $rt;
    }

    public function passes($pass)
    {
        $rt = true;
        $this->result = $this->evaluate($pass);

        foreach($this->result as $k => $v)
        {
            if(!$v)
            {
                $rt = false;
                break;
            }
        }

        return $rt;
    }

    public function getResult()
    {
        return $this->result;
    }

    public function weight()
    {

    }

    public function getMessages()
    {
        return $this->messages;
    }
}