<?php

namespace DPP\Security\Password\Rule;

class StringSetRule implements Rule
{
    private $patterns;

    public function __construct()
    {
        $this->patterns = array();
    }

    public function setValue($val)
    {
        if(is_array($val))
        {
            foreach($val as $v)
            {
                $this->patterns[] = (string) $v;
            }
        }
    }

    public function evaluate($pass)
    {
        return !(in_array($pass, $this->patterns));
    }

    public function weight()
    {

    }

    public function metric($wg)
    {

    }

    public function identifier()
    {
        return sprintf("%s_%s", get_class($this), implode("|", $this->patterns));
    }

    public function message()
    {
        return sprintf("Cannot match the string set %s", implode(",", $this->patterns));
    }
}