<?php

namespace DPP\Security\Password\Rule;

class StringRule extends PatternRule
{
    public function __construct()
    {
        parent::__construct();
    }

    public function evaluate($pass)
    {
        return (strpos($this->pattern, $pass) !== 0);
    }

    public function weight()
    {
        return 0.5;
    }

    public function message()
    {
        return sprintf("Cannot match the string %s", $this->pattern);
    }
}