<?php

namespace DPP\Security\Password\Rule;

class SequentialRule implements Rule
{
    const SEQUENCE = 4;

    private $value;

    public function __construct()
    {
        $this->value = self::SEQUENCE;
    }

    public function setValue($val)
    {
        if(!empty($val))
        {
            $this->value = (int) $val;
        }
        else
        {
            $this->value = self::SEQUENCE;
        }
    }

    public function evaluate($pass)
    {
        $rt = true;
        $count = strlen($pass);
        $vals = [];

        if($count >= $this->value)
        {
            for($i=0; $i<$count; $i++)
            {
                $vals[] = ord($pass[$i]);
                $vCount = count($vals);

                if($vCount > $this->value)
                {
                    array_shift($vals);
                }

                if(($vCount < $this->value) && ($i < ($count - 1)))
                {
                    continue;
                }

                $nVal = [];
                $uCo = count($vals);

                for($j=1; $j<$uCo; $j++)
                {
                    $nVal[] = $vals[$j] - $vals[$j - 1];
                }

                $nVal = array_unique($nVal);

                if($nVal[0] == $nVal[count($nVal) - 1])
                {
                    $rt = false;
                    break;
                }
            }
        }

        return $rt;
    }

    public function weight()
    {
        return 0.5;
    }

    public function metric($wg)
    {

    }

    public function identifier()
    {
        return sprintf("%s_%s", get_class($this), $this->value);
    }

    public function message()
    {
        return sprintf("Cannot be a sequence");
    }
}