<?php

namespace DPP\Security\Password\Rule;

abstract class PatternRule implements Rule
{
    protected $pattern;

    public function __construct()
    {
        $this->pattern = null;
    }

    public function setValue($val)
    {
        $this->pattern = (string) $val;
    }

    public function metric($wg)
    {

    }

    public function identifier()
    {
        return sprintf("%s_%s", get_class($this), $this->pattern);
    }

    public abstract function evaluate($pass);
    public abstract function weight();

}