<?php

namespace DPP\Security\Password\Rule;

class NonAlphaNumericalRule extends InclusionRule
{
    public function __construct()
    {
        parent::__construct();
    }

    public function get()
    {
        return "/\W/";
    }

    public function message()
    {
        return sprintf("Must have at least %s non-alphanumeric characters", $this->count);
    }
}