<?php

namespace DPP\Security\Password\Rule;

class MinLengthRule implements Rule
{
    private $length;

    public function __construct()
    {
        $this->length = null;
    }

    public function setValue($val)
    {
        $this->length = (int) $val;
    }

    public function weight()
    {
        return 0;
    }

    public function evaluate($pass)
    {echo $this->length;
        return (strlen($pass) >= $this->length);
    }

    public function metric($wg)
    {

    }

    public function identifier()
    {
        return sprintf("%s_%s", get_class($this), $this->length);
    }

    public function message()
    {
        return sprintf("Must be at least %s characters long", $this->length);
    }
}