<?php

namespace DPP\Security\Password\Rule;

class MailRule extends PatternRule
{
    const EMAIL_PATTERN = "/^(.*?)@(.*?)\.(\w{3,4})$/";

    public function __construct()
    {
        parent::__construct();
    }

    public function evaluate($pass)
    {
        return !(preg_match(self::EMAIL_PATTERN, $pass));
    }

    public function weight()
    {
        return 0.5;
    }

    public function message()
    {
        return sprintf("Cannot be an email address");
    }
}