<?php

namespace DPP\Security\Password\Rule;

abstract class InclusionRule implements Rule
{
    protected $count;
    protected $pattern;

    public function __construct()
    {
        $this->count = null;
        $this->pattern = $this->get();
    }

    public function setValue($val)
    {
        $this->count = (int) $val;
    }

    public function identifier()
    {
        return sprintf("%s_%s", get_class($this), $this->count);
    }

    public function metric($wg)
    {
        return 0.5;
    }

    public function evaluate($pass)
    {
        $rt = false;
        $nt = preg_match_all($this->pattern, $pass);

        if($nt >= $this->count)
        {
            $rt = true;
        }

        return $rt;
    }

    public function weight()
    {
        return 0.5;
    }

    protected abstract function get();
}