<?php

namespace DPP\Security\Password;

use DPP\Security\Password\Rule\MaxLengthRule;
use DPP\Security\Password\Rule\MinLengthRule;
use DPP\Security\Password\Rule\StringRule;
use DPP\Security\Password\Rule\MailRule;
use DPP\Security\Password\Rule\StringSetRule;
use DPP\Security\Password\Rule\SequentialRule;
use DPP\Security\Password\Rule\UpperCaseRule;
use DPP\Security\Password\Rule\LowerCaseRule;
use DPP\Security\Password\Rule\NumericalRule;
use DPP\Security\Password\Rule\NonAlphaNumericalRule;

class FactoryForRules
{
    private static $DOMAINS = array("debtpaypro.com");

    const MAX_LENGTH = "MAX_LENGTH";
    const MIN_LENGTH = "MIN_LENGTH";
    const STRING = "STRING";
    const MAIL = "MAIL";
    const STRING_SET = "STRING_SET";
    const SEQUENTIAL = "SEQUENTIAL";
    const UPPER = "UPPER";
    const LOWER = "LOWER";
    const NUMERICAL = "NUMERICAL";
    const NON = "NON";

    private $ruleSet;
    private $lockedIn;

    public function __construct()
    {
        $this->ruleSet = new RuleSet();
        $this->lockedIn = false;
    }

    public static function getDPPStandard($un)
    {
        $rt = self::start();

        $rt->add(self::MIN_LENGTH, 8);
        $rt->add(self::MAX_LENGTH, 20);
        $rt->add(self::UPPER, 1);
        $rt->add(self::LOWER, 1);
        $rt->add(self::NON, 1);
        $rt->add(self::MAIL);
        $rt->add(self::STRING, $un);
        $rt->add(self::STRING_SET, self::$DOMAINS);
        $rt->add(self::SEQUENTIAL, 4);

        return $rt->build();
    }

    public static function start()
    {
        return new FactoryForRules();
    }

    public function add($type, $val = null, $wgt = 0.0)
    {
        if(!$this->lockedIn)
        {
            $r = null;

            switch($type)
            {
                case self::MAX_LENGTH: { $r = new MaxLengthRule(); break; }
                case self::MIN_LENGTH: { $r = new MinLengthRule(); break; }
                case self::STRING: { $r = new StringRule(); break; }
                case self::MAIL: { $r = new MailRule(); break; }
                case self::STRING_SET: { $r = new StringSetRule(); break; }
                case self::SEQUENTIAL: { $r = new SequentialRule(); break; }
                case self::UPPER: { $r = new UpperCaseRule(); break; }
                case self::LOWER: { $r = new LowerCaseRule(); break; }
                case self::NUMERICAL: { $r = new NumericalRule(); break; }
                case self::NON: { $r = new NonAlphaNumericalRule(); break; }
            }

            $r->setValue($val);
            $this->ruleSet->add($r);
        }

        return $this;
    }

    public function build()
    {
        $this->ruleSet->lock();
        $this->lockedIn = true;
        return $this->ruleSet;
    }
}