<?php

namespace DPP\Security\Cryptography\JWT\Exceptions;

use DPP\Security\Cryptography\JWT\Exceptions\InvalidJwtException;


/**
 * An exception when attempting to use an unsecured Token.
 */

class UndefinedTokenException extends InvalidJwtException
{
    /**
     * Construct a JWT related exception.
     *
     * @param string   $msg
     */
    public function __construct($msg = '')
    {
        $message = 'Undefined';

        if($msg)
            $message .= ': ' . $msg;

        parent::__construct($message);
    }
}
