<?php

namespace DPP\Security\Cryptography\JWT\Exceptions;

use DPP\Security\Cryptography\JWT\Exceptions\InvalidJwtException;


/**
 * An exception thrown when attempting to sign or verify a JWT which
 * does not have algorithm defined in Header.
 */
class UndefinedEncryptionKeyException extends InvalidJwtException
{
    /**
     * Construct a JWT related exception.
     *
     * @param string   $msg
     */
    public function __construct($msg = '')
    {
        $message = 'Undefined Encryption Key';

        if($msg)
            $message .= ': ' . $msg;

        parent::__construct($message);
    }
}
