<?php

    namespace DPP\Security\Cryptography\JWT;


    trait tHeader
    {

// *******************************************************************
// Class methods

        /**
         * Set a new value for a given header field.
         *
         * @param  string $headerField
         * @param  mixed  $headerValue
         *
         * @return JWT
         */
        protected function setHeaderField($headerField, $headerValue)
        {
            /** @var string $headerField */
            $headerField = strtolower($headerField);

            self::$header->$headerField = $headerValue;

            return $this;
        }

        /**
         * Retrieve the current value of a given header field.
         *
         * @param  string $headerField
         * @return mixed
         */
        protected function getHeaderField($headerField)
        {
            return (isset(self::$header->$headerField))
                ? self::$header->$headerField
                : null;
        }

        /**
         * Remove entire Header definition.
         *
         * @return void
         */
        protected function clearHeaders ()
        {
            self::$header = (object)[ 'alg' => null ];

            // set TYPE back to default
            $this->setTypeHeader();
        }

        // TYP: JWT Type
        /**
         * Set the Token Type.
         *
         * @link https://tools.ietf.org/html/rfc7519#section-3.1
         *
         * @param string|bool $typeValue
         *
         * @return JWT
         */
        protected function setTypeHeader($typeValue = false) {
            if($typeValue === false) {
                $typeValue = 'JWT';
            }

            $this->setHeaderField('typ', $typeValue);

            return $this;
        }

        // ALG: Algorithm
        /**
         * Set the type of Algorithm to be used to encrypt token.
         *
         * @link https://tools.ietf.org/html/rfc7519#section-3.1
         *
         * @param string|bool $algType
         *
         * @return JWT
         * @TODO verify ALGO type given is supported
         */
        final public function setAlgorithm($algType = false)
        {
            if($algType === false) {
                $algType = self::DEFAULT_ALGORITHM ;
            }

            $this->setHeaderField('alg', $algType);

            return $this;
        }

        /**
         * Retrieve the type of Algorithm to be used to encrypt token.
         *
         * @link https://tools.ietf.org/html/rfc7519#section-3.1
         *
         * @return string|bool $algTyped
         */
        private static function getAlgorithm()
        {
            return self::$header->alg;
        }
    }
