<?php

namespace DPP\Financial\Scheduling\Amortization;

use DPP\Financial\Interest\Interest;
use DPP\Financial\Scheduling\ScheduledPayment;
use DPP\Financial\Scheduling\Scheduler;

class FixedPrincipalAmortizationScheduler extends Scheduler
{
    const NAME = "Fixed Principal";
    const SHORT_NAME = "fixed_principal";
    const CLASS_NAME = "FixedPrincipalAmortizationCalculator";

    public function __construct($amt, $air, Frequency $pf, DateTime $id, DateTime $fd = null, $pa = null, Frequency $cp = null)
    {
        parent::__construct($amt, $air, $pf, $id, $fd, $pa, $cp);
    }

    protected function fixedScheduleFinal(array $ds)
    {
        $rt = array();
        $ft = $this->totalAmount;
        $pa = $this->paymentAmount;

        foreach ($ds as $d)
        {
            $ip = null;

            $io = Interest::Get($d->annual(), $ft, $this->paymentFrequency->partOfYear(), $this->compoundFrequency);
            $ip = $io->value();

            $pm = round($pa + $ip, Interest::ROUNDING_PRECISION);

            if ($ft < $pm)
            {
                $ip = 0;
                $pa = $ft;
            }

            $ft -= $pa;

            // On last payment, add to principal and zero out the remaining balance
            if (count($rt) === (count($ds) - 1))
            {
                $pa += $ft;
                $ft = 0.0;
            }

            $d->lock($pa, $ip, $ft);
            $rt[] = $d;

            if ($ft <= 0.0)
            {
                break;
            }
        }

        return $rt;
    }

    protected function adHocScheduleFinal()
    {
        $rt = array();

        $nd = clone $this->firstPaymentDate;
        $ft = $this->totalAmount;
        $pa = $this->paymentAmount;
        $od = null;

        while ($ft > 0.0) {
            $ip = null;

            $io = Interest::Get($this->annualInterestRate, $ft, $this->paymentFrequency->partOfYear(), $this->compoundFrequency);
            $ip = $io->value();

            if ($ft < $this->paymentAmount) {
                $ip = 0;
                $pa = $ft;
            }

            $ft -= $pa;
            $ns = new ScheduledPayment($nd, $od, $this->annualInterestRate);

            $ns->lock($pa, $ip, $ft);
            $rt[] = $ns;

            $od = $nd;
            $nd = $this->paymentFrequency->getNextDate($nd);
        }

        return $rt;
    }
}