<?php

namespace DPP\Financial\Interest;

use DPP\Financial\Balance;

use DPP\Financial\Time\Frequency;
use DPP\Financial\Time\Daily;

class AverageDailyBalanceInterest extends Interest
{
    /**
     * @var Balance[]
     */
    private $balances;

    /**
     * DailyBalanceInterest constructor.
     *
     * @param float      $air
     * @param Balance[]  $bs
     * @param Frequency  $f
     */
    public function __construct($air, array $bs)
    {
        parent::__construct($air);

        $this->balances = $bs;
    }

    /**
     * @return float
     */
    protected function calculate()
    {
        $amt = 0.0;

        if(count($this->balances) === 0)
        {
            return $amt;
        }

        foreach($this->balances as $b)
        {
            $amt += $b->amount();
        }

        return ($amt / count($this->balances)) / $this->getInterestPartOfFrequency(new Daily());
    }
}