<?php

namespace DPP\Financial\Time\Holiday;

use \DateTime;

/**
 * Class FourthOfJuly
 *
 * @package DPP\Financial\Time\Holiday
 */
class FourthOfJuly extends Holiday
{
    const NAME = "Fourth of July";
    const SHORT_NAME = "fourth_of_july";

    /**
     * FourthOfJuly constructor.
     */
    public function __construct()
    {
        parent::__construct(self::NAME, self::SHORT_NAME);
    }

    /**
     * @param DateTime $dt
     * @return bool
     */
    public function isHoliday(DateTime $dt)
    {
        $m = (int) $dt->format("m");
        $d = (int) $dt->format("d");

        return (($m === 7) && ($d === 4));
    }
}