<?php

namespace DPP\Financial;

/**
 * Class IncrementType
 *
 * @package DPP\Financial
 */
class IncrementType
{
    private $name;
    private $short_name;
    private $year_splitter;

    /**
     * IncrementType constructor.
     *
     * @param int $v
     */
    public function __construct($v)
    {
        $this->name       = sprintf("%s/1", $v);
        $this->short_name = sprintf("%s_1", $v);

        $this->year_splitter = $v;
    }

    /**
     * @return IncrementType[]
     */
    final public static function getList()
    {
        $rt = array();

        $rt[] = new IncrementType(2);
        $rt[] = new IncrementType(3);
        $rt[] = new IncrementType(4);
        $rt[] = new IncrementType(10);

        return $rt;
    }

    /**
     * @param string $tp
     * @return IncrementType|null
     * @throws FinancialException
     */
    final public static function getIncrementType($tp)
    {
        $rt  = null;
        $its = self::getList();

        foreach ($its as $i)
        {
            if ($i->shortName() === $tp)
            {
                $rt = $i;
                break;
            }
        }

        if ($rt === null)
        {
            throw new FinancialException(sprintf("Increment type string '%s' is invalid", $tp));
        }

        return $rt;
    }

    /**
     * @param string $n
     * @return IncrementType|null
     */
    final public static function getByName($n)
    {
        $rt  = null;
        $its = self::getList();

        foreach ($its as $i)
        {
            if ($i->short_name === $n)
            {
                $rt = $i;
                break;
            }
        }

        return $rt;
    }

    /**
     * @return string
     */
    public function name()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function shortName()
    {
        return $this->short_name;
    }

    /**
     * @return int
     */
    public function years()
    {
        return $this->year_splitter;
    }
}