<?php

namespace DPP\Financial\Factorization;

use DPP\Financial\ScheduledPayment;

/**
 * Class Factorization
 *
 * @package DPP\Financial\Factorization
 */
class Factorization
{
    private $total;
    private $rate;
    private $payment;
    private $schedule;

    /**
     * Factorization constructor.
     *
     * @param            $tt
     * @param            $ra
     * @param            $pmt
     * @param array|null $sc
     */
    public function __construct($tt, $ra, $pmt, array $sc = null)
    {
        $this->total   = $tt;
        $this->rate    = $ra;
        $this->payment = $pmt;

        $this->schedule = $sc;
    }

    public function paymentCount()
    {
        return count($this->schedule);
    }

    public function paymentTotal()
    {
        return ($this->total * (1 + $this->rate));
    }

    public function interestTotal()
    {
        return ($this->rate * $this->total);
    }

    public function principalTotal()
    {
        return $this->total;
    }

    public function currency()
    {
        return "$";
    }

    public function payments()
    {
        $rt = array();
        $rta = array_keys($this->schedule);
        $pd = null;

        foreach($rta as $d)
        {
            $nd = new DateTime($d);
            $rt[] = new ScheduledPayment($nd, ($pd === null) ? new DateTime() : $pd, $this->rate, $this->schedule[$d]);
            $pd = $nd;
        }

        return $rt;
    }
}