<?php

namespace DPP\Financial\Amortization;

use \DateTime;

use DPP\Financial\FinancialException;
use DPP\Financial\ScheduledPayment;
use DPP\Financial\Interest\Interest;

/**
 * Class InterestOnlyAmortizationCalculator
 *
 * @package DPP\Financial\Amortization
 */
class InterestOnlyAmortizationCalculator extends AmortizationCalculator
{
    const NAME = "Interest Only";
    const SHORT_NAME = "interest_only";
    const CLASS_NAME = "InterestOnlyAmortizationCalculator";

    /**
     * @param DateTime[] $ds
     * @return ScheduledPayment[]
     * @throws FinancialException
     */
    protected function fixedSchedule(array $ds)
    {
        $rt = array();
        $ft = $this->total_amount;

        foreach ($ds as $d)
        {
            $io = Interest::Get($d->annual(), $ft, $this->payment_frequency->partOfYear(), $this->compound_frequency);
            $ip = $io->value();

            $pm = 0;

            $d->lock($pm, $ip, $ft);
            $rt[] = $d;

            if ($ft <= 0.0)
            {
                break;
            }
        }

        return $rt;
    }

    /**
     * @throws FinancialException
     */
    protected function adHocSchedule()
    {
        throw new FinancialException("Ad hoc not possible for interest-only");
    }
}