<?php

namespace DPP\Financial\Time\Holiday;

use \DateTime;

/**
 * Class NewYearsDay
 *
 * @package DPP\Financial\Time\Holiday
 */
class NewYearsDay extends Holiday
{
    const NAME = "New Year's Day";
    const SHORT_NAME = "new_years_day";

    /**
     * NewYearsDay constructor.
     */
    public function __construct()
    {
        parent::__construct(self::NAME, self::SHORT_NAME);
    }

    /**
     * @param DateTime $dt
     * @return bool
     */
    public function isHoliday(DateTime $dt)
    {
        $y  = $dt->format("Y");
        $nd = DateTime::createFromFormat("Y-m-d", sprintf("%s-01-01", $y));

        $ndf = $nd->format("Y-m-d");
        $odf = $dt->format("Y-m-d");

        return ($ndf === $odf);
    }
}