<?php

namespace DPP\Financial\Service;

use \DateTime;

use DPP\Financial\ScheduledPayment;

/**
 * Class Payment
 *
 * @package DPP\Financial
 */
class Payment
{
    /**
     * @var ScheduledPayment
     */
    private $scheduledPayment;
    private $date;
    private $amount;

    /**
     * Payment constructor.
     *
     * @param ScheduledPayment  $sp
     * @param DateTime          $d
     * @param float             $a
     */
    public function __construct(ScheduledPayment $sp, DateTime $d, $a)
    {
        $this->scheduledPayment = $sp;
        $this->date   = $d;
        $this->amount = $a;
    }

    /**
     * @return DateTime
     */
    public function date()
    {
        return $this->date;
    }

    /**
     * @return float
     */
    public function amount()
    {
        return $this->amount;
    }

    /**
     * @return bool
     */
    public function isOnTime()
    {
        return ($this->date === $this->scheduledPayment->date());
    }

    /**
     * @return bool
     */
    public function isAmountCorrect()
    {
        return ($this->amount === $this->scheduledPayment->amount());
    }

    /**
     * @return float
     */
    public function amountDiff()
    {
        return ($this->amount - $this->scheduledPayment->amount());
    }

    /**
     * @return float
     */
    public function principalPaid()
    {
        return $this->scheduledPayment->principal() + $this->amountDiff();
    }
}