<?php

namespace DPP\Financial\Time\Holiday;

use \DateTime;

/**
 * Class Holiday
 *
 * @package DPP\Financial\Time\Holiday
 */
abstract class Holiday
{
    private $name;
    private $short_name;

    /**
     * Holiday constructor.
     *
     * @param string $n
     * @param string $sn
     */
    public function __construct($n, $sn)
    {
        $this->name       = $n;
        $this->short_name = $sn;
    }

    /**
     * @return self[]
     */
    final public static function getList()
    {
        $rt = array();

        $rt[] = new NewYearsDay();
        $rt[] = new PresidentsDay();
        $rt[] = new FourthOfJuly();

        return $rt;
    }

    public function name()
    {
        return $this->name;
    }

    public function shortName()
    {
        return $this->short_name;
    }

    /**
     * @param DateTime $dt
     * @return bool
     */
    abstract public function isHoliday(DateTime $dt);
}