<?php

namespace DPP\Financial\Interest;

use DPP\Financial\Time\Frequency;

/**
 * Class SimpleInterest
 *
 * @package DPP\Financial\Interest
 */
class SimpleInterest extends Interest
{
    protected $principal;
    protected $number_of_years;

    /**
     * SimpleInterest constructor.
     *
     * @param float $air
     * @param float $p
     * @param float $noy
     */
    public function __construct($air, $p, $noy)
    {
        parent::__construct($air);

        $this->principal = $p;
        $this->number_of_years = $noy;
    }

    /**
     * @return float
     */
    protected function calculate($noy = null)
    {
        $noy = ($noy !== null) ? $noy : $this->number_of_years;
        return $this->principal * ($this->annual_interest_rate * $noy);
    }
}