<?php

namespace DPP\Financial\Factorization;

use \DateTime;

use DPP\Financial\Interest\Interest;
use DPP\Financial\Time\Frequency;

/**
 * Class FactorizationCalculator
 *
 * @package DPP\Financial\Factorization
 */
class FactorizationCalculator
{
    const STANDARD_DATE_FORMAT = "Y-m-d";

    private $rate;
    private $amount;
    private $terms;
    /**
     * @var Frequency
     */
    private $payment_frequency;

    /**
     * @param           $ra
     * @param           $am
     * @param null      $tm
     * @param Frequency $f
     * @return FactorizationCalculator
     */
    public static function create($ra, $am, $tm = null, Frequency $f)
    {
        $rt = new self();

        $rt->rate              = $ra;
        $rt->amount            = $am;
        $rt->terms             = $tm;
        $rt->payment_frequency = $f;

        return $rt;
    }

    /**
     * @return Factorization
     */
    public function run()
    {
        $tt  = round($this->amount * $this->rate, Interest::ROUNDING_PRECISION);
        $apt = $tt;
        $sch = null;

        if ($this->terms !== null)
        {
            $apt = round($tt / $this->terms, Interest::ROUNDING_PRECISION);

            $sch = array();
            $ntt = $tt;

            if ($this->payment_frequency !== null)
            {
                $ndt = new DateTime();

                while ($ntt > 0.0)
                {
                    $ndt = $this->payment_frequency->getNextDate($ndt);
                    $ntt = ($ntt < $apt) ? $ntt : ($ntt = $apt);

                    $sch[$ndt->format(self::STANDARD_DATE_FORMAT)] = $ntt;
                }
            }
        }

        return new Factorization($tt, $this->rate, $apt, $sch);
    }
}
