<?php

namespace DPP\Financial\Time;

use \DateTime;
use \DateInterval;

use DPP\Financial\FinancialException;

/**
 * Class Weekly
 *
 * @package DPP\Amortization\Time
 */
class Weekly extends Frequency
{
    /**
     * Weekly constructor.
     */
    public function __construct()
    {
        parent::__construct("Weekly", "weekly");
    }

    /**
     * @return float|int
     */
    public function partOfYear()
    {
        return (7 / $this->daysInYear);
    }

    /**
     * @param DateTime $dt
     * @return DateTime
     * @throws FinancialException
     */
    public function getNextDate(DateTime $dt)
    {
        $rt = $this->copy($dt);
        $rt->add(DateInterval::createFromDateString("1 week"));

        return $rt;
    }

    /**
     * @return int
     */
    public function termsInAYear()
    {
        return 52;
    }

    /**
     * @return int
     */
    public function daysInTerm()
    {
        return 7;
    }
}
