<?php

namespace DPP\Financial\Time;

use \DateTime;
use \DateInterval;

use DPP\Financial\FinancialException;

/**
 * Class SemiMonthly
 *
 * @package DPP\Financial\Time
 */
class SemiMonthly extends Frequency
{
    const DEFAULT_FIRST = 1;
    const DEFAULT_LAST = 15;

    private $firstDate;
    private $lastDate;

    /**
     * SemiMonthly constructor.
     *
     * @param DateTime|null $fd
     * @param DateTime|null $ld
     */
    public function __construct(DateTime $fd = null, DateTime $ld = null)
    {
        parent::__construct("Semi Monthly", "semi_monthly");

        $this->firstDate = $fd;
        $this->lastDate = $ld;
    }

    /**
     * @return float|int
     */
    public function partOfYear()
    {
        return ($this->lastDateInterval !== null) ? ($this->lastDateInterval->format("%a") / $this->daysInYear) : 0;
    }

    /**
     * @param DateTime $dt
     * @return DateTime
     * @throws FinancialException
     */
    public function getNextDate(DateTime $dt)
    {
        $rt = $this->copy($dt);
        $dim = cal_days_in_month(CAL_GREGORIAN, (int) $dt->format("m"), (int) $dt->format("Y"));

        $da = (int) $rt->format("d");
        $da += 15;

        if($da > $dim)
        {
            $da = $dim;
        }

        $yr = (int) $rt->format("Y");
        $mo = (int) $rt->format("m");

        $rt->setDate($yr, $mo, $da);

        return $rt;
    }

    /**
     * @return int
     */
    public function termsInAYear()
    {
        return 24;
    }

    /**
     * @return int
     */
    public function daysInTerm()
    {
        return 15;
    }
}
