<?php

namespace DPP\Financial\Time;

use \DateTime;

use DPP\Financial\FinancialException;

/**
 * Class SemiAnnually
 *
 * @package DPP\Financial\Time
 */
class SemiAnnually extends Frequency
{
    /**
     * SemiAnnually constructor.
     */
    public function __construct()
    {
        parent::__construct("Semi Annually", "semi_annually");
    }

    /**
     * @return float|int
     */
    public function partOfYear()
    {
        return ($this->lastDateInterval !== null) ? ((int) $this->lastDateInterval->format("%a")) / $this->daysInYear : 0;
    }

    /**
     * @param DateTime $dt
     * @return DateTime
     * @throws FinancialException
     */
    public function getNextDate(DateTime $dt)
    {
        $rt = $this->copy($dt);

        $yr = (int) $rt->format("Y");
        $mo = (int) $rt->format("m");
        $da = (int) $rt->format("d");

        for($i=0; $i<6; $i++)
        {
            $mo++;
        }

        $rt->setDate($yr, $mo, $da);
        $this->lastDateInterval = $rt->diff($dt);

        return $rt;
    }

    /**
     * @return int
     */
    public function termsInAYear()
    {
        return 2;
    }

    /**
     * @return int
     */
    public function daysInTerm()
    {
        return 180;
    }
}
