<?php

namespace DPP\Financial\Time;

use \DateTime;

use DPP\Financial\FinancialException;

/**
 * Class Quarterly
 *
 * @package DPP\Financial\Time
 */
class Quarterly extends Frequency
{
    /**
     * Quarterly constructor.
     */
    public function __construct()
    {
        parent::__construct("Quarterly", "quarterly");
    }

    /**
     * @return float|int
     */
    public function partOfYear()
    {
        return ($this->lastDateInterval !== null) ? ((int) $this->lastDateInterval->format("%a")) / $this->daysInYear : 0;
    }

    /**
     * @param DateTime $dt
     * @return DateTime
     * @throws FinancialException
     */
    public function getNextDate(DateTime $dt)
    {
        $rt = $this->copy($dt);

        $yr = (int) $rt->format("Y");
        $mo = (int) $rt->format("m") + 1;
        $da = (int) $rt->format("d");

        for($i=0; $i<3; $i++)
        {
            if($mo === 12)
            {
                $yr++;
            }

            $mo++;
        }

        $rt->setDate($yr, $mo, $da);
        $this->lastDateInterval = $rt->diff($dt);

        return $rt;
    }

    /**
     * @return int
     */
    public function termsInAYear()
    {
        return 4;
    }

    /**
     * @return int
     */
    public function daysInTerm()
    {
        return 90;
    }
}
