<?php

namespace DPP\Financial\Time;

use \DateTime;
use \DateInterval;

use DPP\Financial\FinancialException;

class ExactDays extends Frequency
{
    private $days;

    public function __construct($ds = null)
    {
        parent::__construct("ExactDays", "exact_days");

        $this->days = $ds;
    }

    public function partOfYear()
    {
        return $this->days / $this->daysInYear;
    }

    public function getNextDate(DateTime $dt)
    {
        $rt = $this->copy($dt);
        $rt->add(DateInterval::createFromDateString(sprintf("%s days", $this->days)));

        return $rt;
    }

    public function termsInAYear()
    {
        return 1 / $this->partOfYear();
    }

    public function daysInTerm()
    {
        return $this->days;
    }
}