<?php

namespace DPP\Financial\Time;

use \DateTime;
use \DateInterval;

use DPP\Financial\FinancialException;

/**
 * Class BiWeekly
 *
 * @package DPP\Financial\Time
 */
class BiWeekly extends Frequency
{
    /**
     * BiWeekly constructor.
     */
    public function __construct()
    {
        parent::__construct("Bi Weekly", "bi_weekly");
    }

    /**
     * @return float|int
     */
    public function partOfYear()
    {
        return (14 / $this->daysInYear);
    }

    /**
     * @param DateTime $dt
     * @return DateTime
     * @throws FinancialException
     */
    public function getNextDate(DateTime $dt)
    {
        $rt = $this->copy($dt);
        $rt->add(DateInterval::createFromDateString("2 weeks"));

        return $rt;
    }

    /**
     * @return int
     */
    public function termsInAYear()
    {
        return 26;
    }

    /**
     * @return int
     */
    public function daysInTerm()
    {
        return 14;
    }
}
