<?php

namespace DPP\Financial\Scheduling;

use DPP\Financial\Scheduling\Amortization\InterestAccumulatorAmortizationScheduler;
use DPP\Financial\Scheduling\Factorization\FactorizationScheduler;
use DPP\Financial\Scheduling\Amortization\NormalAmortizationScheduler;
use DPP\Financial\Scheduling\Amortization\FixedPrincipalAmortizationScheduler;
use DPP\Financial\Scheduling\Amortization\InterestOnlyAmortizationScheduler;
use DPP\Financial\FinancialException;

class Method
{
    private $name;
    private $short_name;

    private $class_name;

    public function __construct($n, $sn, $cn)
    {
        $this->name       = $n;
        $this->short_name = $sn;
        $this->class_name = $cn;
    }

    final public static function NORMAL()
    {
        return new Method(NormalAmortizationScheduler::NAME, NormalAmortizationScheduler::SHORT_NAME, NormalAmortizationScheduler::CLASS_NAME);
    }

    final public static function FIXED_PRINCIPAL()
    {
        return new Method(FixedPrincipalAmortizationScheduler::NAME, FixedPrincipalAmortizationScheduler::SHORT_NAME, FixedPrincipalAmortizationScheduler::CLASS_NAME);
    }

    final public static function INTEREST_ONLY()
    {
        return new Method(InterestOnlyAmortizationScheduler::NAME, InterestOnlyAmortizationScheduler::SHORT_NAME, InterestOnlyAmortizationScheduler::CLASS_NAME);
    }

    final public static function FACTORIZATION()
    {
        return new Method(FactorizationScheduler::NAME, FactorizationScheduler::SHORT_NAME, FactorizationScheduler::CLASS_NAME);
    }

    final public static function INTEREST_ACCUMULATOR()
    {
        return new Method(InterestAccumulatorAmortizationScheduler::NAME, InterestAccumulatorAmortizationScheduler::SHORT_NAME, InterestAccumulatorAmortizationScheduler::CLASS_NAME);
    }

    final public static function getList()
    {
        $rt = array();

        $rt[] = self::NORMAL();
        $rt[] = self::FIXED_PRINCIPAL();
        $rt[] = self::INTEREST_ONLY();
        $rt[] = self::FACTORIZATION();
        $rt[] = self::INTEREST_ACCUMULATOR();

        return $rt;
    }

    final public static function getMethod($ms)
    {
        $rt  = null;
        $mtd = self::getList();

        foreach ($mtd as $m)
        {
            if ($m->shortName() === $ms)
            {
                $rt = $m;
                break;
            }
        }

        if ($rt === null)
        {
            throw new FinancialException(sprintf("Method string '%s' is invalid", $ms));
        }

        return $rt;
    }

    public function name()
    {
        return $this->name;
    }

    public function shortName()
    {
        return $this->short_name;
    }

    public function className()
    {
        return $this->class_name;
    }
}