<?php

namespace DPP\Financial\Scheduling\Amortization;

use \DateTime;

use DPP\Financial\FinancialException;
use DPP\Financial\Interest\Interest;
use DPP\Financial\Scheduling\Scheduler;
use DPP\Financial\Time\Frequency;

class InterestOnlyAmortizationScheduler extends Scheduler
{
    const NAME = "Interest Only";
    const SHORT_NAME = "interest_only";
    const CLASS_NAME = "InterestOnlyAmortizationCalculator";

    public function __construct($amt, $air, Frequency $pf, DateTime $id, DateTime $fd = null, $pa = null, Frequency $cp = null)
    {
        parent::__construct($amt, $air, $pf, $id, $fd, $pa, $cp);
    }

    protected function fixedScheduleFinal(array $ds)
    {
        $rt = array();
        $ft = $this->totalAmount;
        $pd = null;

        foreach ($ds as $i => $d)
        {
            $dt  = $d->date();
            $nd = ($pd != null) ? $dt->diff($pd)->days : $dt->diff($this->initialDate)->days;
            $ngoia = $nd / $this->paymentFrequency->daysInYear();

            $io = Interest::Get($d->annual(), $ft, $ngoia, $this->compoundFrequency);
            $ip = $io->value();

            $pm = 0;

            $d->setFinal($pm, $ip, $ft);
            $rt[] = $d;

            if ($ft <= 0.0)
            {
                break;
            }

            $pd = $dt;
        }

        foreach($ds as $i => $d)
        {
            $d->lock();
        }

        return $rt;
    }

    protected function adHocScheduleFinal()
    {
        throw new FinancialException("Ad hoc not possible for interest-only");
    }
}