<?php

namespace DPP\Financial\Scheduling\Amortization;

use \DateTime;

use DPP\Financial\FinancialException;
use DPP\Financial\Interest\Interest;
use DPP\Financial\Scheduling\Scheduler;
use DPP\Financial\Time\Frequency;

class InterestAccumulatorAmortizationScheduler extends Scheduler
{
    const NAME = "Interest Accumulator";
    const SHORT_NAME = "interest_accumulator";
    const CLASS_NAME = "InterestAccumulatorAmortizationCalculator";

    public function __construct($amt, $air, Frequency $pf, DateTime $id, DateTime $fd = null, $pa = null, Frequency $cp = null)
    {
        parent::__construct($amt, $air, $pf, $id, $fd, $pa, $cp);
    }

    protected function fixedScheduleFinal(array $ds)
    {
        $rt = array();
        $ft = $this->totalAmount;
        $pd = null;

        foreach ($ds as $i => $d)
        {
            $dt  = $d->date();
            $nd = ($pd != null) ? $dt->diff($pd)->days : $dt->diff($this->initialDate)->days;
            $ngoia = $nd / $this->paymentFrequency->daysInYear();

            $io = Interest::Get($d->annual(), $ft, $ngoia, $this->compoundFrequency);
            $ip = $io->value();

            $d->setFinal(0.0, 0.0, $this->round($ft + $ip));
            $rt[] = $d;

            $pd = $dt;
        }

        foreach($ds as $i => $d)
        {
            $d->lock();
        }

        return $rt;
    }

    protected function adHocScheduleFinal()
    {
        throw new FinancialException("Ad hoc not possible for interest-accumulation");
    }
}