<?php

namespace DPP\Financial\Interest;

use DPP\Financial\Balance;

use DPP\Financial\Time\Frequency;
use DPP\Financial\Time\Daily;

/**
 * Class DailyBalanceInterest
 *
 * @package DPP\Financial\Interest
 */
class DailyBalanceInterest extends Interest
{
    /**
     * @var Frequency
     */
    private $compounding_frequency;

    /**
     * @var Balance[]
     */
    private $balances;

    /**
     * DailyBalanceInterest constructor.
     *
     * @param float      $air
     * @param Balance[]  $bs
     * @param Frequency  $f
     */
    public function __construct($air, array $bs, Frequency $f)
    {
        parent::__construct($air);

        $this->balances = $bs;
        $this->compounding_frequency = $f;
    }

    /**
     * @return float
     */
    protected function calculate()
    {
        $rt = 0.0;
        $ac = 0.0;

        if(count($this->balances) === 0)
        {
            return $rt;
        }

        $nd = $this->compounding_frequency->getNextDate($this->balances[0]->date());
        $ia = $this->getInterestPartOfFrequency(new Daily());

        foreach($this->balances as $b)
        {
            $amt = $b->amount();
            $amt = ($amt >= 0.0) ? $amt : 0.0;

            $ac += ($amt + $rt) * $ia;

            if($nd === $b->date())
            {
                $rt += $ac;
                $ac = 0.0;

                $nd = $this->compounding_frequency->getNextDate($b->date());
            }
        }

        if($ac > 0.0)
        {
            $rt += $ac;
        }

        return $rt;
    }
}