<?php

namespace DPP\Financial\Time\Holiday;

use \DateTime;
use \DateInterval;

class VeteransDay extends Holiday
{
    const NAME = "Veteran's Day";
    const SHORT_NAME = "veterans_day";

    public function __construct()
    {
        parent::__construct(self::NAME, self::SHORT_NAME);
    }

    public function isHoliday(DateTime $dt)
    {
        $y  = (int) $dt->format("Y");
        $nd = DateTime::createFromFormat("Y-m-d", sprintf("%s-11-11", $y));

        $d  = (int) $nd->format("w");

        if($d === 6)
        {
            $nd->sub(DateInterval::createFromDateString("1 day"));
        }
        else if($d === 0)
        {
            $nd->add(DateInterval::createFromDateString("1 day"));
        }

        $ndf = $nd->format("Y-m-d");
        $odf = $dt->format("Y-m-d");

        return ($ndf === $odf);
    }
}