<?php

namespace DPP\Financial\Scheduling\Factorization;

use \DateTime;
use \Exception;

use DPP\Financial\Interest\Interest;
use DPP\Financial\Time\Frequency;
use DPP\Financial\Scheduling\Scheduler;
use DPP\Financial\Scheduling\ScheduledPayment;

class FactorizationScheduler extends Scheduler
{
    const NAME = "Factorization";
    const SHORT_NAME = "factorization";
    const CLASS_NAME = "FactorizationCalculator";

    const STANDARD_DATE_FORMAT = "Y-m-d";

    public function __construct($amt, $air, Frequency $f, DateTime $id)
    {
        parent::__construct($amt, $air, $f, $id, null, null, null);
    }

    protected function getDateSeriesByTermCount($tc)
    {
        $dts = array();
        $dts[] = new ScheduledPayment(clone $this->firstPaymentDate, clone $this->initialDate, $this->annualInterestRate);

        $fd = $this->firstPaymentDate;
        $ntc = $tc - count($dts);

        while ($ntc > 0)
        {
            $pd = $this->paymentFrequency->getNextDate($fd);
            $dts[] = new ScheduledPayment($pd, $fd, $this->annualInterestRate);

            $fd = $pd;
            $ntc--;
        }

        return $dts;
    }

    public function adHocScheduleFinal()
    {
        throw new Exception("Unsuppored operation");
    }

    protected function fixedScheduleFinal(array $dts)
    {
        $rt = array();
        $tt  = round($this->totalAmount * (1 + $this->annualInterestRate), Interest::ROUNDING_PRECISION);
        $ntt = $tt;

        $pp = $tt / count($dts);
        $ip = ($tt - $this->totalAmount) / count($dts);

        foreach($dts as $d)
        {
            $ntt -= $pp;
            $d->lock($pp, $ip, $ntt);

            $rt[] = $d;
        }

        return $rt;
    }
}
