<?php

namespace DPP\Financial\Time\Holiday;

use \DateTime;
use \DateInterval;

class LaborDay extends Holiday
{
    const NAME = "Labor Day";
    const SHORT_NAME = "labor_day";

    public function __construct()
    {
        parent::__construct(self::NAME, self::SHORT_NAME);
    }

    public function isHoliday(DateTime $dt)
    {
        $y  = (int) $dt->format("Y");
        $nd = DateTime::createFromFormat("Y-m-d", sprintf("%s-09-01", $y));

        $d  = (int) $nd->format("w");

        while($d !== 1)
        {
            $nd->add(DateInterval::createFromDateString("1 day"));
            $d = $nd->format("w");
        }

        $ndf = $nd->format("Y-m-d");
        $odf = $dt->format("Y-m-d");

        return ($ndf === $odf);
    }
}