<?php

namespace DPP\Financial\Time\Holiday;

use \DateTime;
use \DateInterval;

class ColumbusDay extends Holiday
{
    const NAME = "Columbus Day";
    const SHORT_NAME = "columbus_day";

    public function __construct()
    {
        parent::__construct(self::NAME, self::SHORT_NAME);
    }

    public function isHoliday(DateTime $dt)
    {
        $y  = (int) $dt->format("Y");
        $nd = DateTime::createFromFormat("Y-m-d", sprintf("%s-10-01", $y));

        $wk = 1;
        $d  = (int) $nd->format("w");

        while (($d !== 1) && ($wk !== 2))
        {
            if ($d === 1)
            {
                $wk++;
            }

            $nd->add(DateInterval::createFromDateString("1 day"));
            $d = $nd->format("w");
        }

        $ndf = $nd->format("Y-m-d");
        $odf = $dt->format("Y-m-d");

        return ($ndf === $odf);
    }
}
