<?php

namespace DPP\Financial\Time;

use \DateTime;
use \DateInterval;

use DPP\Financial\FinancialException;

/**
 * Class Daily
 *
 * @package DPP\Financial\Time
 */
class Daily extends Frequency
{
    /**
     * Daily constructor.
     */
    public function __construct()
    {
        parent::__construct("Daily", "daily");
    }

    /**
     * @return float|int
     */
    public function partOfYear()
    {
        return (1 / 365);
    }

    /**
     * @param DateTime $dt
     * @return DateTime
     * @throws FinancialException
     */
    public function getNextDate(DateTime $dt)
    {
        $rt = $this->copy($dt);
        $rt->add(DateInterval::createFromDateString("1 day"));

        return $rt;
    }

    /**
     * @return int
     */
    public function termsInAYear()
    {
        return 365;
    }

    /**
     * @return int
     */
    public function daysInTerm()
    {
        return 1;
    }
}
