<?php

namespace DPP\Financial\Interest;

use DPP\Financial\Time\Continuous;
use DPP\Financial\Time\Frequency;

/**
 * Class CompoundInterest
 *
 * @package DPP\Financial\Interest
 */
class CompoundInterest extends SimpleInterest
{
    /**
     * @var Frequency
     */
    private $compounding_frequency;

    /**
     * CompoundInterest constructor.
     *
     * @param float     $air
     * @param float     $p
     * @param float     $noy
     * @param Frequency $f
     */
    public function __construct($air, $p, $noy, Frequency $f)
    {
        parent::__construct($air, $p, $noy);

        $this->compounding_frequency = $f;
    }

    /**
     * @Override
     * @return float
     */
    protected function calculate($noy = null)
    {
        $ip = null;
        $noy = ($noy !== null) ? $noy : $this->number_of_years;

        if ($this->compounding_frequency instanceof Continuous)
        {
            $ip = $this->principal * (M_E ** ($this->annual_interest_rate * $noy));
        }
        else if ($this->number_of_years > 0)
        {
            $ncy = $this->compounding_frequency->termsInAYear();
            $ip  = $this->principal * ((1 + ($this->annual_interest_rate / $ncy)) ** ($ncy * $noy));
        }
        else
        {
            $ip = $this->principal;
        }

        return ($ip - $this->principal);
    }
}