<?php

namespace DPP\Financial\Time;

use \DateTime as DateTime;
use \DateInterval as DateInterval;

use DPP\Financial\FinancialException as FinancialException;

/**
 * Class Weekly
 *
 * @package DPP\Amortization\Time
 */
class Weekly extends Frequency
{
    /**
     * Weekly constructor.
     */
    public function __construct()
    {
        parent::__construct(3, "Weekly", "weekly");
    }

    /**
     * @return float|int
     */
    public function partOfYear()
    {
        return (1 / 52);
    }

    /**
     * @param DateTime $dt
     * @return DateTime
     * @throws FinancialException
     */
    public function getNextDate(DateTime $dt)
    {
        $rt = $this->copy($dt);
        $rt->add(DateInterval::createFromDateString("1 week"));

        return $rt;
    }

    /**
     * @return int
     */
    public function termsInAYear()
    {
        return 52;
    }

    /**
     * @return int
     */
    public function daysInTerm()
    {
        return 7;
    }
}