<?php

namespace DPP\Financial\Time;

use \DateTime as DateTime;
use \DateInterval as DateInterval;

use DPP\Financial\FinancialException as FinancialException;

/**
 * Class SemiMonthly
 *
 * @package DPP\Financial\Time
 */
class SemiMonthly extends Frequency
{
    /**
     * SemiMonthly constructor.
     */
    public function __construct()
    {
        parent::__construct(5, "Semi Monthly", "semi_monthly");
    }

    /**
     * @return float|int
     */
    public function partOfYear()
    {
        return ($this->lastDateInterval != null) ? ($this->lastDateInterval->format("%a") / 365) : 0;
    }

    /**
     * @param DateTime $dt
     * @return DateTime
     * @throws FinancialException
     */
    public function getNextDate(DateTime $dt)
    {
        $rt = $this->copy($dt);

        if($dt->format("d") < 15)
        {
            $rt->setDate($dt->format("Y"), $dt->format("m"), 15);
        }
        else
        {
            $rt->add(DateInterval::createFromDateString("1 month"));
            $rt->setDate($rt->format("Y"), $rt->format("m"), 1);
        }

        $this->lastDateInterval = $rt->diff($dt);

        return $rt;
    }

    /**
     * @return int
     */
    public function termsInAYear()
    {
        return 24;
    }

    /**
     * @return int
     */
    public function daysInTerm()
    {
        return 15;
    }
}