<?php

namespace DPP\Financial\Time\Holiday;

use \DateTime as DateTime;

/**
 * Class Holiday
 *
 * @package DPP\Financial\Time\Holiday
 */
abstract class Holiday
{
    private $id;

    private $name;
    private $shortName;

    /**
     * Holiday constructor.
     *
     * @param int $i
     * @param string $n
     * @param string $sn
     */
    public function __construct($i, $n, $sn)
    {
        $this->id = $i;

        $this->name = $n;
        $this->shortName = $sn;
    }

    /**
     * @return self[]
     */
    public static final function getList()
    {
        $rt = array();

        $rt[] = new NewYearsDay();
        $rt[] = new PresidentsDay();
        $rt[] = new FourthOfJuly();

        return $rt;
    }

    /**
     * @param DateTime $dt
     * @return bool
     */
    public abstract function isHoliday(DateTime $dt);
}